<?php

namespace App\Enums;

enum DifficultyLevel: string
{
    case EASY = 'easy';
    case MEDIUM = 'medium';
    case HARD = 'hard';

    public function getLabel(): string
    {
        return match ($this) {
            self::EASY => 'Easy',
            self::MEDIUM => 'Medium',
            self::HARD => 'Hard',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::EASY => 'success',
            self::MEDIUM => 'warning',
            self::HARD => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::EASY => 'heroicon-o-star',
            self::MEDIUM => 'heroicon-o-fire',
            self::HARD => 'heroicon-o-bolt',
        };
    }
}
