<?php

namespace App\Enums;

enum NavigationGroup: string
{
    case CBT_MANAGEMENT = 'CBT Management';
    case USER_MANAGEMENT = 'User Management';
    case SYSTEM_CONFIG = 'System Configuration';
    case REPORTS = 'Reports & Analytics';
    case SETTINGS = 'Settings';

    /**
     * Get a user-friendly label for the navigation group
     */
    public function getLabel(): string
    {
        return $this->value;
    }

    /**
     * Get the icon for the navigation group
     */
    public function getIcon(): string
    {
        return match ($this) {
            self::CBT_MANAGEMENT => 'heroicon-o-academic-cap',
            self::USER_MANAGEMENT => 'heroicon-o-users',
            self::SYSTEM_CONFIG => 'heroicon-o-cog-6-tooth',
            self::REPORTS => 'heroicon-o-chart-bar',
            self::SETTINGS => 'heroicon-o-adjustments-horizontal',
        };
    }

    /**
     * Get the sort order for the navigation group
     */
    public function getSortOrder(): int
    {
        return match ($this) {
            self::CBT_MANAGEMENT => 10,
            self::USER_MANAGEMENT => 20,
            self::REPORTS => 30,
            self::SYSTEM_CONFIG => 40,
            self::SETTINGS => 50,
        };
    }
}
