<?php

namespace App\Filament\Resources\Exams\Pages;

use App\Filament\Resources\Exams\ExamResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditExam extends EditRecord
{
    protected static string $resource = ExamResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make(),
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $data['updated_by'] = auth()->id();

        return $data;
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Convert category distribution from associative format {"1": 13} to simple array [1]
        if (isset($data['category_distribution']) && is_array($data['category_distribution'])) {
            // If it's an associative array (old format), extract just the keys (category IDs)
            $keys = array_keys($data['category_distribution']);
            // Check if this is associative (old format) or already a simple array
            if (!empty($keys) && !is_int($keys[0])) {
                // Old format {"1": 13, "2": 5} - extract keys as category IDs
                $data['category_distribution'] = array_map('intval', $keys);
            } elseif (!empty($data['category_distribution']) && isset($data['category_distribution'][0]) && is_array($data['category_distribution'][0])) {
                // Repeater format [{"category_id": 1, "count": 13}] - extract category_ids
                $data['category_distribution'] = array_map(fn($item) => $item['category_id'] ?? null, $data['category_distribution']);
                $data['category_distribution'] = array_filter($data['category_distribution']);
            }
            // If already simple array format [1, 2, 3], leave as is
        }

        return $data;
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
