<?php

namespace App\Filament\Resources\Staff\Schemas\Components;

use Filament\Forms\Components\Select;

class EmploymentStatusSelect
{
    public static function make(): Select
    {
        return Select::make('employment_status')
            ->label('Employment Status')
            ->options([
                'active' => 'Active',
                'inactive' => 'Inactive',
                'suspended' => 'Suspended',
                'terminated' => 'Terminated',
            ])
            ->default('active')
            ->required()
            ->suffixIcon('heroicon-m-check-circle');
    }
}