<?php

namespace App\Filament\Resources\Staff\Schemas\Components;

use App\Models\Staff;
use App\Settings\TerminologySettings;
use Filament\Forms\Components\TextInput;

class StaffNumberInput
{
    public static function make(): TextInput
    {
        $terminology = app(TerminologySettings::class);
        
        return TextInput::make('staff_number')
            ->label($terminology->secondary_user_id_label)
            ->required()
            ->unique(Staff::class, 'staff_number', ignoreRecord: true)
            ->maxLength(50)
            ->placeholder('Enter ' . strtolower($terminology->secondary_user_id_label))
            ->helperText('Must be unique across the system')
            ->suffixIcon('heroicon-m-identification');
    }
}