<?php

namespace App\Filament\Widgets;

use App\Models\ExamSession;
use App\Enums\ExamSessionStatus;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class ActiveExamSessions extends BaseWidget
{
    protected static ?string $heading = 'Active & Upcoming Exam Sessions';
    protected static ?int $sort = 4;
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                ExamSession::query()
                    ->with(['exam'])
                    ->whereIn('status', [ExamSessionStatus::ACTIVE, ExamSessionStatus::SCHEDULED])
                    ->orderBy('start_time')
            )
            ->columns([
                Tables\Columns\TextColumn::make('exam.title')
                    ->label('Exam')
                    ->limit(25),
                    
                Tables\Columns\TextColumn::make('title')
                    ->label('Session')
                    ->limit(20),
                    
                Tables\Columns\TextColumn::make('status')
                    ->badge()
                    ->color(fn ($state) => match($state) {
                        ExamSessionStatus::ACTIVE => 'success',
                        ExamSessionStatus::SCHEDULED => 'warning',
                        ExamSessionStatus::COMPLETED => 'gray',
                        default => 'gray',
                    }),
                    
                Tables\Columns\TextColumn::make('start_time')
                    ->label('Start')
                    ->dateTime('M d, H:i'),
                    
                Tables\Columns\TextColumn::make('attempts_count')
                    ->label('Attempts')
                    ->counts('attempts'),
            ])
            ->paginated([5, 10, 25]);
    }
}
