<?php

namespace App\Filament\Widgets;

use App\Models\ExamAttempt;
use App\Enums\ExamAttemptStatus;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Carbon;

class ExamPerformanceChart extends ChartWidget
{
    protected static ?int $sort = 2;
    protected ?string $heading = 'Exam Performance (Last 7 Days)';
    protected int | string | array $columnSpan = 'full';
    protected ?string $maxHeight = '250px';

    protected function getData(): array
    {
        $data = collect(range(6, 0))->map(function ($daysAgo) {
            $date = Carbon::now()->subDays($daysAgo)->startOfDay();
            
            $attempts = ExamAttempt::whereDate('completed_at', $date)
                ->where('status', ExamAttemptStatus::COMPLETED)
                ->get();
            
            $total = $attempts->count();
            $passed = $attempts->where('passed', true)->count();
            $avgScore = $total > 0 ? round($attempts->avg('score_percentage'), 1) : 0;
            
            return [
                'date' => $date->format('M d'),
                'attempts' => $total,
                'passed' => $passed,
                'avgScore' => $avgScore,
            ];
        });

        return [
            'datasets' => [
                [
                    'label' => 'Total Attempts',
                    'data' => $data->pluck('attempts')->toArray(),
                    'backgroundColor' => 'rgba(59, 130, 246, 0.5)',
                    'borderColor' => 'rgb(59, 130, 246)',
                ],
                [
                    'label' => 'Passed',
                    'data' => $data->pluck('passed')->toArray(),
                    'backgroundColor' => 'rgba(34, 197, 94, 0.5)',
                    'borderColor' => 'rgb(34, 197, 94)',
                ],
            ],
            'labels' => $data->pluck('date')->toArray(),
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
