<?php

namespace App\Http\Middleware;

use App\Settings\FeatureSettings;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckFeatureEnabled
{
    public function __construct(
        protected FeatureSettings $featureSettings
    ) {}

    /**
     * Handle an incoming request.
     *
     * Checks if the specified feature is enabled.
     * Returns 404 if the feature is disabled.
     *
     * Usage: Route::middleware('feature:secondary_user_exams')
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @param  string  $feature  The feature flag to check
     */
    public function handle(Request $request, Closure $next, string $feature): Response
    {
        if (! $this->featureSettings->isEnabled($feature)) {
            abort(404, 'This feature is not available.');
        }

        return $next($request);
    }
}
