<?php

namespace App\Http\Middleware;

use App\Settings\OrganizationSettings;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureSetupIsComplete
{
    public function __construct(
        protected OrganizationSettings $organizationSettings
    ) {}

    /**
     * Handle an incoming request.
     *
     * Redirects to the setup wizard if the initial setup has not been completed.
     * Allows access to setup routes even when setup is incomplete.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Allow setup routes to pass through
        if ($request->routeIs('setup.*')) {
            return $next($request);
        }

        // Redirect to setup wizard if not completed
        if (! $this->organizationSettings->setup_completed) {
            return redirect()->route('setup.index');
        }

        return $next($request);
    }
}
