<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * Redirects authenticated users to their respective dashboards.
     */
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        // If no guards specified, check both student and staff
        $guards = empty($guards) ? ['student', 'staff'] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                // Redirect to the appropriate dashboard based on guard
                $route = $guard === 'student' ? 'student.dashboard' : 'staff.dashboard';
                return redirect()->route($route);
            }
        }

        return $next($request);
    }
}
