<?php

namespace App\Settings;

use Spatie\LaravelSettings\Settings;

class ExamSettings extends Settings
{
    public int $default_duration_minutes;
    public int $default_passing_score;
    public bool $allow_review;
    public bool $shuffle_questions;
    public bool $shuffle_options;
    public bool $show_score_immediately;
    public bool $show_results_to_students;
    public bool $show_correct_answers_to_students;
    public int $max_attempts;

    public static function group(): string
    {
        return 'exam';
    }

    /**
     * Get duration in seconds.
     */
    public function getDefaultDurationSeconds(): int
    {
        return $this->default_duration_minutes * 60;
    }

    /**
     * Check if a score meets the passing threshold.
     */
    public function isPassing(float $score): bool
    {
        return $score >= $this->default_passing_score;
    }

    /**
     * Get available duration options for forms.
     */
    public static function getDurationOptions(): array
    {
        return [
            15 => '15 minutes',
            30 => '30 minutes',
            45 => '45 minutes',
            60 => '1 hour',
            90 => '1 hour 30 minutes',
            120 => '2 hours',
            150 => '2 hours 30 minutes',
            180 => '3 hours',
        ];
    }
}
