<?php

return [
    /*
    |--------------------------------------------------------------------------
    | CBT System Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains default configuration values for the CBT system.
    | These values are used as defaults when the organization has not yet
    | configured their settings through the setup wizard.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Default Organization Settings
    |--------------------------------------------------------------------------
    */
    'defaults' => [
        'organization' => [
            'name' => 'CBT System',
            'tagline' => 'Computer-Based Testing Platform',
            'contact_email' => null,
            'contact_phone' => null,
            'address' => null,
            'timezone' => 'Africa/Lagos',
        ],

        'branding' => [
            'logo_path' => null,
            'favicon_path' => null,
            'primary_color' => '#2563eb', // blue-600
            'secondary_color' => '#4b5563', // gray-600
            'accent_color' => '#059669', // emerald-600
        ],

        'terminology' => [
            // Primary users (exam takers)
            'primary_user_singular' => 'Student',
            'primary_user_plural' => 'Students',
            'primary_user_id_label' => 'Student ID',
            'primary_user_id_field' => 'matriculation_number',

            // Secondary users (optional - staff taking exams)
            'secondary_user_singular' => 'Staff',
            'secondary_user_plural' => 'Staff',
            'secondary_user_id_label' => 'Staff Number',
            'secondary_user_id_field' => 'staff_number',

            // Academic period labels
            'period_label' => 'Academic Session',
            'period_format' => 'YYYY/YYYY', // e.g., 2024/2025

            // Organizational unit
            'division_label' => 'Department',
        ],

        'features' => [
            'secondary_user_exams' => true, // Staff/secondary user exams
            'practice_mode' => false,
            'certificate_generation' => false,
            'result_printing' => true,
            'bulk_import' => true,
            'api_access' => false,
            'dark_mode' => true,
        ],

        'exam' => [
            'default_duration_minutes' => 60,
            'default_passing_score' => 50,
            'allow_review' => true,
            'shuffle_questions' => true,
            'shuffle_options' => true,
            'show_score_immediately' => true,
            'max_attempts' => 1,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | User Type Presets
    |--------------------------------------------------------------------------
    |
    | Available presets for different organization types.
    | Organizations select a preset during setup, which pre-fills terminology.
    |
    */
    'user_type_presets' => [
        'educational' => [
            'label' => 'Educational Institution',
            'description' => 'Schools, Universities, Training Centers',
            'primary' => [
                'singular' => 'Student',
                'plural' => 'Students',
                'id_label' => 'Matriculation Number',
            ],
            'secondary' => [
                'singular' => 'Staff',
                'plural' => 'Staff',
                'id_label' => 'Staff Number',
            ],
            'period_label' => 'Academic Session',
            'division_label' => 'Department',
        ],

        'corporate' => [
            'label' => 'Corporate / Business',
            'description' => 'Companies, Enterprises, Organizations',
            'primary' => [
                'singular' => 'Employee',
                'plural' => 'Employees',
                'id_label' => 'Employee ID',
            ],
            'secondary' => [
                'singular' => 'Manager',
                'plural' => 'Managers',
                'id_label' => 'Manager ID',
            ],
            'period_label' => 'Assessment Period',
            'division_label' => 'Department',
        ],

        'certification' => [
            'label' => 'Certification Body',
            'description' => 'Professional Certification, Licensing',
            'primary' => [
                'singular' => 'Candidate',
                'plural' => 'Candidates',
                'id_label' => 'Candidate ID',
            ],
            'secondary' => [
                'singular' => 'Examiner',
                'plural' => 'Examiners',
                'id_label' => 'Examiner ID',
            ],
            'period_label' => 'Examination Period',
            'division_label' => 'Category',
        ],

        'healthcare' => [
            'label' => 'Healthcare / Medical',
            'description' => 'Hospitals, Clinics, Medical Training',
            'primary' => [
                'singular' => 'Trainee',
                'plural' => 'Trainees',
                'id_label' => 'Trainee ID',
            ],
            'secondary' => [
                'singular' => 'Staff',
                'plural' => 'Staff',
                'id_label' => 'Staff Number',
            ],
            'period_label' => 'Training Period',
            'division_label' => 'Unit',
        ],

        'government' => [
            'label' => 'Government / Public Sector',
            'description' => 'Government Agencies, Public Service',
            'primary' => [
                'singular' => 'Candidate',
                'plural' => 'Candidates',
                'id_label' => 'Application Number',
            ],
            'secondary' => [
                'singular' => 'Officer',
                'plural' => 'Officers',
                'id_label' => 'Officer ID',
            ],
            'period_label' => 'Recruitment Batch',
            'division_label' => 'Ministry/Agency',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Setup Configuration
    |--------------------------------------------------------------------------
    */
    'setup' => [
        'completed_key' => 'setup_completed',
        'wizard_steps' => [
            'welcome',
            'organization',
            'branding',
            'terminology',
            'features',
            'admin',
            'complete',
        ],
    ],
];
