<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('code')->unique(); // Unique exam code for easy reference
            $table->text('description')->nullable();
            $table->text('instructions')->nullable(); // Instructions shown before exam starts
            
            // Exam configuration
            $table->integer('duration_minutes')->default(60);
            $table->integer('total_questions'); // Number of questions to present
            $table->decimal('passing_score', 5, 2)->default(50.00); // Percentage needed to pass
            $table->integer('marks_per_question')->default(1);
            $table->integer('negative_marking')->default(0); // Points deducted for wrong answers
            
            // Question selection settings
            $table->string('question_selection_type')->default('manual'); // manual, random, category_based
            $table->json('question_ids')->nullable(); // For manual selection
            $table->json('category_distribution')->nullable(); // For category-based {category_id: count}
            
            // Target audience
            $table->string('target_audience'); // student, staff, both
            $table->string('target_period')->nullable(); // Session/period relevance
            $table->string('target_department')->nullable(); // Department relevance
            
            // Behavior settings
            $table->boolean('shuffle_questions')->default(true);
            $table->boolean('shuffle_options')->default(true);
            $table->boolean('show_result_immediately')->default(true);
            $table->boolean('allow_review')->default(true); // Allow reviewing answers before submit
            $table->boolean('show_correct_answers')->default(false); // Show correct answers after completion
            
            // Status and audit
            $table->boolean('is_active')->default(true);
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['is_active', 'target_audience']);
            $table->index('target_period');
            $table->index('target_department');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams');
    }
};
