<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_id')->constrained('exams')->onDelete('cascade');
            $table->string('title')->nullable(); // Optional title like "Morning Session"
            
            // Scheduling
            $table->dateTime('start_time');
            $table->dateTime('end_time');
            
            // Session limits
            $table->integer('max_attempts')->default(1); // Max attempts per candidate
            $table->integer('max_participants')->nullable(); // Optional participant limit
            
            // Access control
            $table->string('access_code')->nullable(); // Optional access code for this session
            $table->json('allowed_candidates')->nullable(); // Specific candidate IDs if restricted
            
            // Status
            $table->string('status')->default('scheduled'); // scheduled, active, completed, cancelled
            $table->text('notes')->nullable(); // Internal notes
            
            // Audit
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
            
            $table->index(['exam_id', 'status']);
            $table->index(['start_time', 'end_time']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_sessions');
    }
};
