<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_attempts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_session_id')->constrained('exam_sessions')->onDelete('cascade');
            
            // Polymorphic candidate (student or staff)
            $table->string('candidate_type'); // App\Models\Student or App\Models\Staff
            $table->unsignedBigInteger('candidate_id');
            
            // Question order for this attempt (shuffled)
            $table->json('question_order'); // Array of question_bank_ids in order shown
            
            // Timing
            $table->dateTime('started_at');
            $table->dateTime('completed_at')->nullable();
            $table->integer('time_spent_seconds')->default(0); // Actual time spent
            
            // Results
            $table->integer('total_questions')->default(0);
            $table->integer('answered_questions')->default(0);
            $table->integer('correct_answers')->default(0);
            $table->integer('wrong_answers')->default(0);
            $table->integer('skipped_questions')->default(0);
            $table->decimal('score_obtained', 8, 2)->default(0);
            $table->decimal('score_percentage', 5, 2)->default(0);
            $table->boolean('passed')->nullable(); // null until completed
            
            // Status
            $table->string('status')->default('in_progress'); // in_progress, completed, abandoned, timed_out
            $table->integer('current_question_index')->default(0); // For resuming if allowed
            
            // Client info for audit
            $table->string('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            
            $table->timestamps();
            
            $table->index(['candidate_type', 'candidate_id']);
            $table->index(['exam_session_id', 'status']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_attempts');
    }
};
