<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add model answer field to question_banks for essay questions
        Schema::table('question_banks', function (Blueprint $table) {
            $table->text('model_answer')->nullable()->after('correct_answer');
            $table->integer('min_words')->nullable()->after('model_answer');
            $table->integer('max_words')->nullable()->after('min_words');
            $table->json('grading_rubric')->nullable()->after('max_words');
        });

        // Add essay grading fields to exam_answers
        Schema::table('exam_answers', function (Blueprint $table) {
            $table->text('essay_answer')->nullable()->after('selected_answer');
            $table->boolean('requires_grading')->default(false)->after('is_skipped');
            $table->boolean('is_graded')->default(false)->after('requires_grading');
            $table->foreignId('graded_by')->nullable()->after('is_graded')
                ->constrained('staff')->nullOnDelete();
            $table->timestamp('graded_at')->nullable()->after('graded_by');
            $table->text('grading_feedback')->nullable()->after('graded_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('exam_answers', function (Blueprint $table) {
            $table->dropForeign(['graded_by']);
            $table->dropColumn([
                'essay_answer',
                'requires_grading',
                'is_graded',
                'graded_by',
                'graded_at',
                'grading_feedback',
            ]);
        });

        Schema::table('question_banks', function (Blueprint $table) {
            $table->dropColumn([
                'model_answer',
                'min_words',
                'max_words',
                'grading_rubric',
            ]);
        });
    }
};