<?php

namespace Database\Seeders;

use App\Enums\DifficultyLevel;
use App\Models\QuestionBank;
use App\Models\QuestionCategory;
use Illuminate\Database\Seeder;

class EssayQuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get or create a category for essay questions
        $category = QuestionCategory::firstOrCreate(
            ['name' => 'General Knowledge'],
            [
                'description' => 'General knowledge and essay questions',
                'is_active' => true,
            ]
        );

        $essayQuestions = [
            [
                'question_text' => 'Discuss the importance of mental health awareness in modern healthcare settings. What strategies can healthcare professionals implement to promote mental wellness among patients and staff?',
                'min_words' => 150,
                'max_words' => 500,
                'difficulty' => DifficultyLevel::MEDIUM,
            ],
            [
                'question_text' => 'Explain the ethical considerations healthcare professionals must take into account when dealing with patient confidentiality. Provide examples of situations where confidentiality might be challenged.',
                'min_words' => 200,
                'max_words' => 600,
                'difficulty' => DifficultyLevel::HARD,
            ],
            [
                'question_text' => 'Describe the role of effective communication in patient care. How can healthcare professionals improve their communication skills?',
                'min_words' => 100,
                'max_words' => 400,
                'difficulty' => DifficultyLevel::EASY,
            ],
            [
                'question_text' => 'Analyze the challenges and benefits of implementing electronic health records (EHR) in healthcare facilities. What recommendations would you make for successful EHR adoption?',
                'min_words' => 200,
                'max_words' => 500,
                'difficulty' => DifficultyLevel::MEDIUM,
            ],
            [
                'question_text' => 'What is your understanding of patient-centered care? Explain how it differs from traditional care models and why it is important.',
                'min_words' => 100,
                'max_words' => 350,
                'difficulty' => DifficultyLevel::EASY,
            ],
        ];

        foreach ($essayQuestions as $question) {
            QuestionBank::create([
                'category_id' => $category->id,
                'question_text' => $question['question_text'],
                'question_type' => 'essay',
                'difficulty' => $question['difficulty'],
                'target_audience' => 'student',
                'options' => [],
                'correct_answer' => '',
                'min_words' => $question['min_words'],
                'max_words' => $question['max_words'],
                'explanation' => '',
                'is_active' => true,
            ]);
        }

        $this->command->info('Created ' . count($essayQuestions) . ' essay questions in the "General Knowledge" category.');
    }
}
