# CBT System - Hosting Recommendations

## Overview

The CBT System requires reliable hosting infrastructure to ensure optimal performance, especially during peak examination periods. Based on our load testing results (successfully handling 1,000+ concurrent users taking 200-question exams), we provide two hosting recommendations depending on your organization's scale and requirements.

---

## Option 1: VPS Hosting (Recommended)

### Minimum Specifications

| Component | Specification |
|-----------|--------------|
| **vCPU Cores** | 2 cores |
| **RAM** | 8 GB |
| **Storage** | 100 GB NVMe SSD |
| **Bandwidth** | 8 TB/month |
| **Operating System** | Ubuntu 22.04 LTS or later |

### Why VPS is Recommended

**Performance & Scalability**
- Dedicated resources ensure consistent performance during peak exam periods
- Can handle 200-500+ concurrent exam takers simultaneously
- No resource sharing with other websites
- Ability to scale resources (CPU, RAM) as your user base grows

**Control & Flexibility**
- Full root access for system optimization
- Install and configure required PHP extensions
- Configure Redis for queue processing and caching
- Set up Laravel Horizon for background job management
- Custom server configurations for optimal performance

**Reliability**
- Isolated environment reduces risk of downtime from other users
- Better uptime guarantees (typically 99.9%+)
- Suitable for organizations with 100-1000+ students

### Recommended VPS Providers

#### International Providers
- **DigitalOcean** - Droplet (Basic 8GB RAM) - ~$48/month
- **Linode (Akamai)** - Dedicated 8GB - ~$36/month
- **Vultr** - High Frequency 8GB - ~$48/month
- **Hetzner** - CPX31 (4 vCPU, 8GB) - ~€13.90/month (~₦25,000)

#### Nigerian Providers
- **Whogohost** - Cloud VPS Enterprise
- **Qservers** - VPS Professional
- **Layer3** - Cloud VPS

### Setup Requirements

Your VPS will need:
- Ubuntu 22.04 LTS (recommended)
- PHP 8.4+ with required extensions
- MySQL 8.x or PostgreSQL 15+
- Redis server
- Nginx or Apache web server
- SSL certificate (free with Let's Encrypt)
- Regular automated backups

**We provide full setup and deployment support with your license.**

---

## Option 2: Shared Hosting

### Minimum Specifications

| Component | Specification |
|-----------|--------------|
| **Disk Space** | 20 GB SSD |
| **Bandwidth** | Unlimited or 500 GB/month minimum |
| **PHP Version** | 8.2+ (8.4 preferred) |
| **Database** | MySQL 8.x or PostgreSQL 15+ |
| **Control Panel** | cPanel or DirectAdmin |

### When to Choose Shared Hosting

**Best For:**
- Small-scale deployments (50-100 concurrent users)
- Organizations with limited technical expertise
- Budget-conscious institutions
- Testing or pilot programs

**Limitations to Consider:**
- Shared resources may impact performance during peak times
- Limited control over server configuration
- May struggle with 150+ concurrent users
- Queue processing might be limited
- No root access for advanced optimizations

### Recommended Shared Hosting Providers

#### Nigerian Providers
- **Hostinger Nigeria** - Business Shared Hosting - From ₦3,000/month
- **Whogohost** - Professional Shared Hosting - From ₦7,500/month
- **Qservers** - Business Hosting Plan

#### International (with Nigerian payment options)
- **Namecheap** - Stellar Plus - ~$4.88/month
- **Hostinger International** - Business Plan - ~$3.99/month

### Important Notes for Shared Hosting

1. **PHP Requirements**: Ensure the host supports:
   - PHP 8.2+ (8.4 recommended)
   - Required extensions: mbstring, xml, pdo, redis, gd, zip, bcmath, intl
   - Composer access

2. **Database**: MySQL 8.x or PostgreSQL 15+ with adequate connection limits

3. **Cron Jobs**: Required for scheduled tasks (exam session status updates, etc.)

4. **Queue Processing**: May be limited; some features requiring background processing might be affected

---

## Cost Comparison

### VPS Hosting
- **Monthly Cost**: ₦25,000 - ₦60,000 (~$16 - $40)
- **Setup Time**: 2-3 hours (with our support)
- **Capacity**: 200-500+ concurrent users
- **Best For**: 200+ students, multiple exam sessions

### Shared Hosting
- **Monthly Cost**: ₦3,000 - ₦10,000 (~$2 - $7)
- **Setup Time**: 1-2 hours
- **Capacity**: 50-100 concurrent users
- **Best For**: <200 students, occasional exams

---

## Our Recommendation

**For most organizations**, we strongly recommend **VPS hosting** because:

1. **Proven Performance**: Our load tests show the system can handle 1,000+ concurrent users on VPS infrastructure
2. **Future-Proof**: Easy to scale as your student population grows
3. **Reliability**: Dedicated resources ensure consistent performance during critical exam periods
4. **Full Features**: All system features work optimally (queue processing, background jobs, etc.)
5. **Cost-Effective**: At ~₦35,000/month, the performance and reliability justify the cost

**Shared hosting** is only recommended for:
- Pilot programs with <100 students
- Organizations testing the system before full deployment
- Very small institutions with infrequent exams

---

## Deployment Support

We provide comprehensive deployment support with your CBT System license:

✅ Server setup and configuration  
✅ Application installation and optimization  
✅ Database setup and migration  
✅ SSL certificate installation  
✅ Performance tuning  
✅ Initial testing and verification  
✅ Documentation and handover  

**Note**: Hosting costs are separate from the system license fee of ₦850,000.

---

## Additional Considerations

### Backup Strategy
Regardless of hosting choice, ensure:
- Daily automated backups of database
- Weekly full system backups
- Off-site backup storage
- Tested restoration procedures

### Security
Both options should include:
- SSL/TLS certificate (HTTPS)
- Firewall configuration
- Regular security updates
- DDoS protection (VPS providers typically include this)

### Monitoring
- Server uptime monitoring
- Performance monitoring during exams
- Error log monitoring
- Database performance tracking

---

## Next Steps

1. **Choose your hosting option** based on your organization's needs and budget
2. **Contact us** with your hosting choice for deployment planning
3. **We'll provide** detailed setup instructions or handle deployment for you
4. **Testing period** to ensure everything works perfectly before live deployment

---

**Questions or Need Assistance?**

Contact us for:
- Hosting provider recommendations specific to your location
- Custom hosting requirements assessment
- Deployment scheduling
- Performance optimization consultation

---

*Document Version: 1.0*  
*Last Updated: January 2026*
