<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    @php
        $organizationSettings = app(\App\Settings\OrganizationSettings::class);
        $brandingSettings = app(\App\Settings\BrandingSettings::class);
        $appName = $organizationSettings->name ?? config('app.name', 'CBT System');
        $faviconUrl = $brandingSettings->getFaviconUrl() ?? $brandingSettings->getLogoUrl();
    @endphp
    
    <title>{{ $title ?? $appName }}</title>
    
    @if($faviconUrl)
        <link rel="icon" href="{{ $faviconUrl }}" type="image/x-icon">
        <link rel="shortcut icon" href="{{ $faviconUrl }}" type="image/x-icon">
    @endif
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Additional Styles -->
    @stack('styles')
</head>
<body class="font-sans text-gray-900 antialiased h-full">
    <div class="min-h-full">
        {{ $slot }}
    </div>
    
    <!-- Additional Scripts -->
    @stack('scripts')
</body>
</html>