<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    @php
        $organizationSettings = app(\App\Settings\OrganizationSettings::class);
        $brandingSettings = app(\App\Settings\BrandingSettings::class);
        $appName = $organizationSettings->name ?? config('app.name', 'CBT System');
        $faviconUrl = $brandingSettings->getFaviconUrl() ?? $brandingSettings->getLogoUrl();
    @endphp

    <title>{{ $title ?? 'Dashboard' }} - {{ $appName }}</title>

    @if($faviconUrl)
        <link rel="icon" href="{{ $faviconUrl }}" type="image/x-icon">
        <link rel="shortcut icon" href="{{ $faviconUrl }}" type="image/x-icon">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="h-full bg-gray-50 font-sans antialiased">
    <div class="min-h-full">
        <!-- Navigation -->
        <nav class="bg-white shadow-sm border-b border-gray-200">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <div class="flex h-16 justify-between items-center">
                    <!-- Logo and Title -->
                    <div class="flex items-center space-x-4">
                        <x-app-logo size="sm" />
                        <div>
                            <h1 class="text-lg font-semibold text-gray-900">{{ $appName }}</h1>
                            <p class="text-sm text-gray-500">{{ $subtitle ?? 'Dashboard' }}</p>
                        </div>
                    </div>

                    <!-- User Menu -->
                    <div class="flex items-center space-x-4">
                        <div class="text-right">
                            <p class="text-sm font-medium text-gray-900">{{ $userName }}</p>
                            <p class="text-xs text-gray-500">{{ $userRole }}</p>
                        </div>
                        
                        <!-- Logout Button -->
                        <form method="POST" action="{{ $logoutRoute }}">
                            @csrf
                            <button type="submit" 
                                class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:bg-gray-50 hover:text-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 transition ease-in-out duration-150">
                                <svg class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15m3 0l3-3m0 0l-3-3m3 3H9" />
                                </svg>
                                Logout
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="py-8">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <!-- Page Header -->
                <div class="mb-8">
                    <h2 class="text-2xl font-bold text-gray-900">{{ $pageTitle }}</h2>
                    @if(isset($pageDescription))
                        <p class="mt-1 text-sm text-gray-600">{{ $pageDescription }}</p>
                    @endif
                </div>

                <!-- Dashboard Content -->
                {{ $slot }}
            </div>
        </main>
    </div>
</body>
</html>