<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    @php
        $organizationSettings = app(\App\Settings\OrganizationSettings::class);
        $brandingSettings = app(\App\Settings\BrandingSettings::class);
        $appName = $organizationSettings->name ?? config('app.name', 'CBT System');
        $faviconUrl = $brandingSettings->getFaviconUrl() ?? $brandingSettings->getLogoUrl();
    @endphp

    <title>{{ $title ?? 'Setup Wizard' }} - {{ $appName }}</title>

    @if($faviconUrl)
        <link rel="icon" href="{{ $faviconUrl }}" type="image/x-icon">
        <link rel="shortcut icon" href="{{ $faviconUrl }}" type="image/x-icon">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        :root {
            --color-primary: {{ $brandingSettings->primary_color }};
            --color-secondary: {{ $brandingSettings->secondary_color }};
            --color-accent: {{ $brandingSettings->accent_color }};
        }
    </style>
</head>
<body class="h-full bg-gradient-to-br from-slate-50 to-slate-100 antialiased">
    <div class="min-h-full">
        {{ $slot }}
    </div>
</body>
</html>
