@props([
    'title',
    'value',
    'description' => null,
    'icon' => null,
    'color' => 'emerald',
    'trend' => null,
    'trendDirection' => 'up'
])

@php
$colorClasses = [
    'emerald' => 'bg-emerald-50 text-emerald-600',
    'blue' => 'bg-blue-50 text-blue-600',
    'amber' => 'bg-amber-50 text-amber-600',
    'red' => 'bg-red-50 text-red-600',
    'purple' => 'bg-purple-50 text-purple-600',
    'indigo' => 'bg-indigo-50 text-indigo-600',
];

$iconBg = $colorClasses[$color] ?? $colorClasses['emerald'];
@endphp

<div class="bg-white overflow-hidden shadow-sm rounded-lg border border-gray-200 hover:shadow-md transition-shadow duration-200">
    <div class="p-6">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                @if($icon)
                    <div class="w-12 h-12 rounded-lg {{ $iconBg }} flex items-center justify-center">
                        <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            {!! $icon !!}
                        </svg>
                    </div>
                @endif
            </div>
            <div class="ml-5 w-0 flex-1">
                <dl>
                    <dt class="text-sm font-medium text-gray-500 truncate">{{ $title }}</dt>
                    <dd class="flex items-baseline">
                        <div class="text-2xl font-semibold text-gray-900">{{ $value }}</div>
                        @if($trend)
                            <div class="ml-2 flex items-baseline text-sm font-semibold {{ $trendDirection === 'up' ? 'text-green-600' : 'text-red-600' }}">
                                <svg class="self-center flex-shrink-0 h-4 w-4 {{ $trendDirection === 'up' ? 'text-green-500' : 'text-red-500' }}" 
                                     fill="currentColor" viewBox="0 0 20 20">
                                    @if($trendDirection === 'up')
                                        <path fill-rule="evenodd" d="M5.293 9.707a1 1 0 010-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 01-1.414 1.414L11 7.414V15a1 1 0 11-2 0V7.414L6.707 9.707a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                                    @else
                                        <path fill-rule="evenodd" d="M14.707 10.293a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 111.414-1.414L9 12.586V5a1 1 0 012 0v7.586l2.293-2.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                    @endif
                                </svg>
                                <span class="ml-1">{{ $trend }}</span>
                            </div>
                        @endif
                    </dd>
                    @if($description)
                        <dd class="mt-1 text-sm text-gray-600">{{ $description }}</dd>
                    @endif
                </dl>
            </div>
        </div>
    </div>
</div>