@php
    $branding = app(\App\Settings\BrandingSettings::class);
    $organization = app(\App\Settings\OrganizationSettings::class);
    $appName = $organization->name ?? config('app.name', 'CBT System');
    $faviconUrl = $branding->getFaviconUrl() ?? $branding->getLogoUrl();
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $title ?? 'Exam Portal' }} - {{ $appName }}</title>

    @if($faviconUrl)
        <link rel="icon" href="{{ $faviconUrl }}" type="image/x-icon">
        <link rel="shortcut icon" href="{{ $faviconUrl }}" type="image/x-icon">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="h-full bg-gray-100 font-sans antialiased">
    <div class="min-h-full">
        <!-- Navigation -->
        <nav class="bg-white shadow-sm border-b border-gray-200">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <div class="flex h-16 justify-between items-center">
                    <!-- Logo and Title -->
                    <div class="flex items-center space-x-4">
                        <x-app-logo size="sm" />
                        <div>
                            <h1 class="text-lg font-semibold text-gray-900">{{ $appName }}</h1>
                            <p class="text-sm text-gray-500">Examination Portal</p>
                        </div>
                    </div>

                    <!-- User Info -->
                    <div class="flex items-center space-x-4">
                        <!-- Timer will be rendered by Livewire component -->
                        <div id="timer-container"></div>
                        
                        <div class="text-right">
                            <p class="text-sm font-medium text-gray-900">{{ $userName ?? 'Candidate' }}</p>
                            <p class="text-xs text-gray-500">{{ $userRole ?? 'Exam Candidate' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="py-6">
            {{ $slot }}
        </main>
    </div>
</body>
</html>
