<div class="min-h-full bg-gray-50">
    @php
        $guard = session('guard', 'student');
        $user = auth($guard)->user();
        $terminology = app(\App\Settings\TerminologySettings::class);
        
        // Guard-aware route helpers
        $examTakeRoute = $guard === 'student' ? 'exam.take' : 'staff.exam.take';
        $examResultRoute = $guard === 'student' ? 'exam.result' : 'staff.exam.result';
    @endphp

    @include('partials.dashboard-nav', [
        'subtitle' => 'Exam Portal',
        'userName' => $user->name ?? $user->full_name ?? 'Candidate',
        'userRole' => $guard === 'student' ? $terminology->primary_user_singular : $terminology->secondary_user_singular,
        'logoutRoute' => route($guard . '.logout')
    ])

    <!-- Main Content -->
    <main class="py-8">
        <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <!-- Page Header -->
            <div class="mb-8">
                <h2 class="text-2xl font-bold text-gray-900">Examinations</h2>
                <p class="mt-1 text-sm text-gray-600">View and take available exams</p>
            </div>

            <div class="space-y-6">
                <!-- Search and Filters -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4">
                    <div class="flex flex-col sm:flex-row gap-4">
                        <!-- Search -->
                        <div class="flex-1">
                            <label for="search" class="sr-only">Search exams</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                                    </svg>
                                </div>
                                <input 
                                    type="text" 
                                    wire:model.live.debounce.300ms="search"
                                    id="search"
                                    class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-lg text-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500"
                                    placeholder="Search by exam title or code..."
                                >
                            </div>
                        </div>

                        <!-- Filter Tabs -->
                        <div class="flex space-x-2">
                            <button 
                                wire:click="$set('filter', 'available')"
                                class="px-4 py-2 text-sm font-medium rounded-lg {{ $filter === 'available' ? 'bg-emerald-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}"
                            >
                                Available Now
                            </button>
                            <button 
                                wire:click="$set('filter', 'upcoming')"
                                class="px-4 py-2 text-sm font-medium rounded-lg {{ $filter === 'upcoming' ? 'bg-emerald-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}"
                            >
                                Upcoming
                            </button>
                            <button 
                                wire:click="$set('filter', 'completed')"
                                class="px-4 py-2 text-sm font-medium rounded-lg {{ $filter === 'completed' ? 'bg-emerald-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}"
                            >
                                Completed
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Exam List -->
                @if($sessions->isEmpty())
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-12 text-center">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h3.75M9 15h3.75M9 18h3.75m3-18v18a2.25 2.25 0 01-2.25 2.25H6.108c-1.135 0-2.098-.708-2.474-1.618a4.5 4.5 0 010-2.364C3.982 3.708 4.946 3 6.108 3h9.142a2.25 2.25 0 012.25 2.25z" />
                        </svg>
                        <h3 class="mt-4 text-lg font-medium text-gray-900">No exams found</h3>
                        <p class="mt-2 text-sm text-gray-500">
                            @if($filter === 'available')
                                There are no exams available right now. Check back later or view upcoming exams.
                            @elseif($filter === 'upcoming')
                                There are no upcoming exams scheduled for you.
                            @else
                                You haven't completed any exams yet.
                            @endif
                        </p>
                    </div>
                @else
                    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
                        @foreach($sessions as $session)
                            <div wire:key="session-{{ $session->id }}" class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden hover:shadow-md transition-shadow">
                                <!-- Card Header -->
                                <div class="p-4 border-b border-gray-200">
                                    <div class="flex items-start justify-between">
                                        <div>
                                            <div class="flex items-center gap-2 mb-2">
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                    {{ $session->exam->code }}
                                                </span>
                                                @if($session->exam->question_type === 'essay')
                                                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-amber-100 text-amber-800">
                                                        Essay
                                                    </span>
                                                @else
                                                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                        MCQ
                                                    </span>
                                                @endif
                                            </div>
                                            <h3 class="text-lg font-semibold text-gray-900">{{ $session->exam->title }}</h3>
                                            @if($session->title)
                                                <p class="text-sm text-gray-500">{{ $session->title }}</p>
                                            @endif
                                        </div>
                                        @if($session->status->value === 'active' && $session->isWithinTimeWindow())
                                            <span class="flex h-3 w-3 relative">
                                                <span class="animate-ping absolute inline-flex h-3 w-3 rounded-full bg-green-400 opacity-75"></span>
                                                <span class="relative inline-flex rounded-full h-3 w-3 bg-green-500"></span>
                                            </span>
                                        @endif
                                    </div>
                                </div>

                                <!-- Card Body -->
                                <div class="p-4">
                                    <dl class="grid grid-cols-2 gap-4 text-sm">
                                        <div>
                                            <dt class="text-gray-500">Duration</dt>
                                            <dd class="font-medium text-gray-900">{{ $session->exam->duration_minutes }} mins</dd>
                                        </div>
                                        <div>
                                            <dt class="text-gray-500">Questions</dt>
                                            <dd class="font-medium text-gray-900">{{ $session->exam->total_questions }}</dd>
                                        </div>
                                        <div>
                                            <dt class="text-gray-500">Pass Mark</dt>
                                            <dd class="font-medium text-gray-900">{{ $session->exam->passing_score }}%</dd>
                                        </div>
                                        <div>
                                            <dt class="text-gray-500">Attempts</dt>
                                            <dd class="font-medium text-gray-900">
                                                {{ $session->my_attempts->count() }} / {{ $session->max_attempts }}
                                            </dd>
                                        </div>
                                    </dl>

                                    <!-- Schedule Info -->
                                    <div class="mt-4 pt-4 border-t border-gray-100">
                                        <div class="flex items-center text-sm text-gray-500">
                                            <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                            {{ $session->start_time->format('M d, Y H:i') }} - {{ $session->end_time->format('H:i') }}
                                        </div>
                                    </div>

                                    <!-- Previous Attempt Results -->
                                    @if($showResults && $session->my_attempts->where('status', 'completed')->count() > 0)
                                        <div class="mt-3 p-3 bg-gray-50 rounded-lg">
                                            <p class="text-xs font-medium text-gray-500 mb-2">Previous Results</p>
                                            <div class="space-y-1">
                                                @foreach($session->my_attempts->where('status', 'completed')->take(2) as $attempt)
                                                    <div wire:key="attempt-{{ $attempt->id }}" class="flex items-center justify-between text-sm">
                                                        <span class="text-gray-600">Attempt {{ $loop->iteration }}</span>
                                                        <span class="{{ $attempt->passed ? 'text-green-600' : 'text-red-600' }} font-medium">
                                                            {{ number_format($attempt->score_percentage, 1) }}%
                                                            ({{ $attempt->passed ? 'PASS' : 'FAIL' }})
                                                        </span>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @elseif(!$showResults && $session->my_attempts->where('status', 'completed')->count() > 0)
                                        <div class="mt-3 p-3 bg-gray-50 rounded-lg">
                                            <p class="text-xs font-medium text-gray-500">{{ $session->my_attempts->where('status', 'completed')->count() }} attempt(s) completed</p>
                                        </div>
                                    @endif
                                </div>

                                <!-- Card Footer -->
                                <div class="px-4 py-3 bg-gray-50 border-t border-gray-200">
                                    @if($session->can_take['can_take'])
                                        <a href="{{ route($examTakeRoute, $session) }}" 
                                           class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500">
                                            @if($session->can_take['in_progress_attempt'])
                                                <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.348a1.125 1.125 0 010 1.971l-11.54 6.347a1.125 1.125 0 01-1.667-.985V5.653z" />
                                                </svg>
                                                Resume Exam
                                            @else
                                                <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" />
                                                </svg>
                                                Start Exam
                                            @endif
                                        </a>
                                    @elseif($showResults && $filter === 'completed' && $session->my_attempts->count() > 0)
                                        <a href="{{ route($examResultRoute, $session->my_attempts->last()) }}" 
                                           class="w-full inline-flex justify-center items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500">
                                            <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            </svg>
                                            View Results
                                        </a>
                                    @elseif(!$showResults && $filter === 'completed' && $session->my_attempts->count() > 0)
                                        <div class="w-full inline-flex justify-center items-center px-4 py-2 border border-gray-200 text-sm font-medium rounded-md text-gray-500 bg-gray-50">
                                            <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                            Exam Completed
                                        </div>
                                    @else
                                        <div class="text-sm text-gray-500">
                                            @foreach($session->can_take['reasons'] as $reason)
                                                <p>{{ $reason }}</p>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    <div class="mt-6">
                        {{ $sessions->links() }}
                    </div>
                @endif
            </div>
        </div>
    </main>
</div>
