@php
    $guard = session('guard', 'student');
    
    // Guard-aware route helpers
    $examListRoute = $guard === 'student' ? 'exam.list' : 'staff.exam.list';
    $examTakeRoute = $guard === 'student' ? 'exam.take' : 'staff.exam.take';
    
    // Check if results are pending grading
    $hasPendingEssays = $this->hasPendingEssays;
    $isAllEssay = $this->isAllEssay;
@endphp

<div class="min-h-screen bg-gray-100 py-8">
    <div class="mx-auto max-w-4xl px-4 sm:px-6 lg:px-8">
        @if($attempt)
            {{-- Results Header --}}
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden mb-6">
                @if($hasPendingEssays)
                    {{-- Pending Grading State --}}
                    <div class="p-6 text-center bg-amber-50">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-amber-100">
                            <svg class="h-10 w-10 text-amber-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <h1 class="mt-4 text-3xl font-bold text-amber-900">Awaiting Grading</h1>
                        <p class="mt-2 text-lg text-amber-700">
                            @if($isAllEssay)
                                Your essay responses have been submitted and are awaiting review by an examiner.
                            @else
                                Your exam has been submitted. Essay questions are pending manual grading.
                            @endif
                        </p>
                        <p class="mt-2 text-sm text-amber-600">
                            Final results will be available once grading is complete.
                        </p>
                    </div>
                @elseif($attempt->is_passed)
                    {{-- Passed State --}}
                    <div class="p-6 text-center bg-emerald-50">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-emerald-100">
                            <svg class="h-10 w-10 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12c0 1.268-.63 2.39-1.593 3.068a3.745 3.745 0 01-1.043 3.296 3.745 3.745 0 01-3.296 1.043A3.745 3.745 0 0112 21c-1.268 0-2.39-.63-3.068-1.593a3.746 3.746 0 01-3.296-1.043 3.745 3.745 0 01-1.043-3.296A3.745 3.745 0 013 12c0-1.268.63-2.39 1.593-3.068a3.745 3.745 0 011.043-3.296 3.746 3.746 0 013.296-1.043A3.746 3.746 0 0112 3c1.268 0 2.39.63 3.068 1.593a3.746 3.746 0 013.296 1.043 3.746 3.746 0 011.043 3.296A3.745 3.745 0 0121 12z" />
                            </svg>
                        </div>
                        <h1 class="mt-4 text-3xl font-bold text-emerald-900">Congratulations!</h1>
                        <p class="mt-2 text-lg text-emerald-700">You have passed the exam.</p>
                    </div>
                @else
                    {{-- Failed State --}}
                    <div class="p-6 text-center bg-red-50">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-red-100">
                            <svg class="h-10 w-10 text-red-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9.75 9.75l4.5 4.5m0-4.5l-4.5 4.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <h1 class="mt-4 text-3xl font-bold text-red-900">Exam Not Passed</h1>
                        <p class="mt-2 text-lg text-red-700">You did not meet the passing criteria.</p>
                    </div>
                @endif

                <div class="p-6 border-b border-gray-200">
                    <div class="text-center">
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                            {{ $attempt->examSession->exam->code }}
                        </span>
                        <h2 class="mt-2 text-xl font-semibold text-gray-900">{{ $attempt->examSession->exam->title }}</h2>
                        @if($attempt->examSession->title)
                            <p class="text-sm text-gray-500">{{ $attempt->examSession->title }}</p>
                        @endif
                    </div>
                </div>

                {{-- Score Summary --}}
                {{-- Score Summary --}}
                <div class="p-6">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div class="text-center p-4 bg-gray-50 rounded-lg">
                            @if($hasPendingEssays && $isAllEssay)
                                <p class="text-3xl font-bold text-amber-600">--</p>
                                <p class="text-sm text-gray-500">Score Pending</p>
                            @else
                                <p class="text-3xl font-bold {{ $hasPendingEssays ? 'text-amber-600' : ($attempt->is_passed ? 'text-emerald-600' : 'text-red-600') }}">
                                    {{ number_format($attempt->score_percentage, 1) }}%
                                    @if($hasPendingEssays)
                                        <span class="text-xs font-normal text-amber-500">*</span>
                                    @endif
                                </p>
                                <p class="text-sm text-gray-500">
                                    @if($hasPendingEssays)
                                        Partial Score
                                    @else
                                        Your Score
                                    @endif
                                </p>
                            @endif
                        </div>
                        <div class="text-center p-4 bg-gray-50 rounded-lg">
                            @if($hasPendingEssays && $isAllEssay)
                                <p class="text-3xl font-bold text-amber-600">--</p>
                            @else
                                <p class="text-3xl font-bold text-gray-900">{{ $attempt->total_score }}</p>
                            @endif
                            <p class="text-sm text-gray-500">Marks Obtained</p>
                        </div>
                        <div class="text-center p-4 bg-gray-50 rounded-lg">
                            <p class="text-3xl font-bold text-gray-900">{{ $attempt->max_score }}</p>
                            <p class="text-sm text-gray-500">Total Marks</p>
                        </div>
                        <div class="text-center p-4 bg-gray-50 rounded-lg">
                            <p class="text-3xl font-bold text-gray-900">{{ $attempt->examSession->exam->passing_score }}%</p>
                            <p class="text-sm text-gray-500">Pass Mark</p>
                        </div>
                    </div>
                    @if($hasPendingEssays && !$isAllEssay)
                        <p class="mt-3 text-xs text-amber-600 text-center">
                            * This is a partial score based on auto-graded questions only. Final score will be updated after essay grading.
                        </p>
                    @endif
                </div>
            </div>

            {{-- Statistics --}}
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden mb-6">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Performance Statistics</h3>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        {{-- Answer Statistics --}}
                        <div>
                            <h4 class="text-sm font-medium text-gray-700 mb-4">Answer Breakdown</h4>
                            <div class="space-y-3">
                                <div class="flex items-center justify-between">
                                    <span class="flex items-center text-sm text-gray-600">
                                        <span class="w-3 h-3 rounded-full bg-emerald-500 mr-2"></span>
                                        Correct Answers
                                    </span>
                                    <span class="text-sm font-medium text-gray-900">{{ $statistics['correct'] ?? 0 }}</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="flex items-center text-sm text-gray-600">
                                        <span class="w-3 h-3 rounded-full bg-red-500 mr-2"></span>
                                        Incorrect Answers
                                    </span>
                                    <span class="text-sm font-medium text-gray-900">{{ $statistics['incorrect'] ?? 0 }}</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="flex items-center text-sm text-gray-600">
                                        <span class="w-3 h-3 rounded-full bg-gray-300 mr-2"></span>
                                        Skipped Questions
                                    </span>
                                    <span class="text-sm font-medium text-gray-900">{{ $statistics['skipped'] ?? 0 }}</span>
                                </div>
                            </div>

                            {{-- Visual Bar --}}
                            <div class="mt-4 h-4 bg-gray-200 rounded-full overflow-hidden flex">
                                @if(($statistics['total'] ?? 0) > 0)
                                    <div 
                                        class="h-full bg-emerald-500" 
                                        style="width: {{ (($statistics['correct'] ?? 0) / $statistics['total']) * 100 }}%"
                                    ></div>
                                    <div 
                                        class="h-full bg-red-500" 
                                        style="width: {{ (($statistics['incorrect'] ?? 0) / $statistics['total']) * 100 }}%"
                                    ></div>
                                    <div 
                                        class="h-full bg-gray-300" 
                                        style="width: {{ (($statistics['skipped'] ?? 0) / $statistics['total']) * 100 }}%"
                                    ></div>
                                @endif
                            </div>
                        </div>

                        {{-- Time Statistics --}}
                        <div>
                            <h4 class="text-sm font-medium text-gray-700 mb-4">Time Information</h4>
                            <dl class="space-y-3">
                                <div class="flex items-center justify-between">
                                    <dt class="text-sm text-gray-600">Started At</dt>
                                    <dd class="text-sm font-medium text-gray-900">
                                        {{ $attempt->started_at?->format('M d, Y h:i A') }}
                                    </dd>
                                </div>
                                <div class="flex items-center justify-between">
                                    <dt class="text-sm text-gray-600">Completed At</dt>
                                    <dd class="text-sm font-medium text-gray-900">
                                        {{ $attempt->completed_at?->format('M d, Y h:i A') }}
                                    </dd>
                                </div>
                                <div class="flex items-center justify-between">
                                    <dt class="text-sm text-gray-600">Time Taken</dt>
                                    <dd class="text-sm font-medium text-gray-900">
                                        @php
                                            $totalSeconds = $attempt->time_spent_seconds ?? 0;
                                            $hours = floor($totalSeconds / 3600);
                                            $minutes = floor(($totalSeconds % 3600) / 60);
                                            $seconds = $totalSeconds % 60;
                                        @endphp
                                        {{ $hours > 0 ? $hours . 'h ' : '' }}{{ $minutes }}m {{ $seconds }}s
                                    </dd>
                                </div>
                                <div class="flex items-center justify-between">
                                    <dt class="text-sm text-gray-600">Duration Allowed</dt>
                                    <dd class="text-sm font-medium text-gray-900">
                                        {{ $attempt->examSession->exam->duration_minutes }} minutes
                                    </dd>
                                </div>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Detailed Answers (if allowed) --}}
            @if($showDetailedResults && count($answers) > 0)
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden mb-6">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-semibold text-gray-900">Detailed Results</h3>
                        <p class="text-sm text-gray-500">
                            @if($showCorrectAnswers)
                                Review your answers and the correct responses
                            @else
                                Review your submitted answers
                            @endif
                        </p>
                    </div>
                    <div class="divide-y divide-gray-200">
                        @foreach($answers as $index => $answer)
                            <div class="p-6">
                                <div class="flex items-start justify-between mb-3">
                                    <span class="text-sm font-medium text-gray-500">Question {{ $index + 1 }}</span>
                                    @if($showCorrectAnswers)
                                        @if($answer['is_correct'])
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800">
                                                <svg class="h-3 w-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                                </svg>
                                                Correct
                                            </span>
                                        @elseif($answer['is_skipped'])
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                Skipped
                                            </span>
                                        @else
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                <svg class="h-3 w-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                </svg>
                                                Incorrect
                                            </span>
                                        @endif
                                    @elseif($answer['is_skipped'])
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                            Skipped
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                            Answered
                                        </span>
                                    @endif
                                </div>

                                <p class="text-gray-900 mb-4">{{ $answer['question_text'] }}</p>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
                                    @foreach($answer['options'] as $key => $option)
                                        @php
                                            $isSelected = strcasecmp($answer['selected_answer'] ?? '', $key) === 0;
                                            $isCorrect = strcasecmp($answer['correct_answer'] ?? '', $key) === 0;
                                        @endphp
                                        <div class="flex items-center p-3 rounded-lg border-2 
                                            @if($showCorrectAnswers)
                                                @if($isCorrect)
                                                    border-emerald-400 bg-emerald-50
                                                @elseif($isSelected && !$isCorrect)
                                                    border-red-400 bg-red-50
                                                @else
                                                    border-gray-200 bg-gray-50
                                                @endif
                                            @else
                                                @if($isSelected)
                                                    border-blue-400 bg-blue-50
                                                @else
                                                    border-gray-200 bg-gray-50
                                                @endif
                                            @endif
                                        ">
                                            <span class="font-medium mr-2 
                                                @if($showCorrectAnswers)
                                                    @if($isCorrect) text-emerald-700
                                                    @elseif($isSelected) text-red-700
                                                    @else text-gray-600
                                                    @endif
                                                @else
                                                    @if($isSelected) text-blue-700
                                                    @else text-gray-600
                                                    @endif
                                                @endif
                                            ">{{ $key }}.</span>
                                            <span class="flex-1 
                                                @if($showCorrectAnswers)
                                                    @if($isCorrect) text-emerald-900
                                                    @elseif($isSelected) text-red-900
                                                    @else text-gray-700
                                                    @endif
                                                @else
                                                    @if($isSelected) text-blue-900
                                                    @else text-gray-700
                                                    @endif
                                                @endif
                                            ">{{ $option }}</span>
                                            @if($showCorrectAnswers)
                                                @if($isCorrect)
                                                    <svg class="h-5 w-5 text-emerald-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                                    </svg>
                                                @elseif($isSelected && !$isCorrect)
                                                    <svg class="h-5 w-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                    </svg>
                                                @endif
                                            @elseif($isSelected)
                                                <svg class="h-5 w-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                                </svg>
                                            @endif
                                        </div>
                                    @endforeach
                                </div>

                                @if($showCorrectAnswers && !$answer['is_correct'] && !$answer['is_skipped'])
                                    <p class="mt-3 text-sm text-gray-600">
                                        <span class="font-medium">Your answer:</span> {{ $answer['selected_answer'] }} 
                                        <span class="mx-2">|</span>
                                        <span class="font-medium text-emerald-600">Correct answer:</span> {{ $answer['correct_answer'] }}
                                    </p>
                                @endif
                            </div>
                        @endforeach
                    </div>
                </div>
            @elseif(!$showDetailedResults && count($answers) > 0)
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                    <div class="flex">
                        <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                        </svg>
                        <div class="ml-3">
                            <p class="text-sm text-blue-700">
                                Detailed answer review is not available for this exam. Contact your instructor for more information.
                            </p>
                        </div>
                    </div>
                </div>
            @endif

            {{-- Actions --}}
            <div class="flex items-center justify-center space-x-4 pb-8">
                <a 
                    href="{{ route($examListRoute) }}"
                    class="inline-flex items-center px-6 py-3 border border-gray-300 text-base font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50"
                >
                    <svg class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 19.5L3 12m0 0l7.5-7.5M3 12h18" />
                    </svg>
                    Back to Exams
                </a>
                
                @php
                    $candidateType = $guard === 'student' ? \App\Models\Student::class : \App\Models\Staff::class;
                    $canRetake = $attempt->examSession->canCandidateTake($candidateType, auth($guard)->user()->id)['can_take'];
                @endphp
                @if($canRetake)
                    <a 
                        href="{{ route($examTakeRoute, $attempt->examSession) }}"
                        class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-lg text-white bg-emerald-600 hover:bg-emerald-700"
                    >
                        <svg class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99" />
                        </svg>
                        Retake Exam
                    </a>
                @endif
            </div>
        @else
            {{-- Attempt Not Found --}}
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-8 text-center">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9.75 9.75l4.5 4.5m0-4.5l-4.5 4.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <h2 class="mt-4 text-xl font-semibold text-gray-900">Result Not Found</h2>
                <p class="mt-2 text-gray-500">The exam result you're looking for could not be found.</p>
                <a 
                    href="{{ route($examListRoute) }}"
                    class="mt-6 inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-emerald-600 hover:bg-emerald-700"
                >
                    Go to Exam List
                </a>
            </div>
        @endif
    </div>
</div>
