<div 
    class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8"
    x-data="{ redirectUrl: null }"
    x-on:exam-submitted.window="
        {{-- Store URL and let modal close smoothly before redirecting --}}
        redirectUrl = $event.detail.url;
        setTimeout(() => {
            window.location.replace(redirectUrl);
        }, 200);
    "
>
    {{-- Timer Component - Teleported to navbar --}}
    @if($examStarted && $attempt)
        @teleport('#timer-container')
            <div 
                x-data="{ 
                    timeRemaining: @entangle('timeRemaining'),
                    timerInterval: null,
                    alertsPlayed: { tenMin: false, fiveMin: false, oneMin: false },
                    isPulsing: false,
                    audioContext: null,
                    get minutes() { return Math.floor(this.timeRemaining / 60) },
                    get seconds() { return this.timeRemaining % 60 },
                    get display() { 
                        return String(this.minutes).padStart(2, '0') + ':' + String(this.seconds).padStart(2, '0') 
                    },
                    get isWarning() { return this.timeRemaining <= 300 },
                    get isCritical() { return this.timeRemaining <= 60 },
                    initAudio() {
                        // Initialize audio context on first user interaction
                        if (!this.audioContext) {
                            try {
                                const AudioContext = window.AudioContext || window.webkitAudioContext;
                                this.audioContext = new AudioContext();
                            } catch (e) {
                                console.log('Audio not supported');
                            }
                        }
                        // Resume if suspended (browser autoplay policy)
                        if (this.audioContext && this.audioContext.state === 'suspended') {
                            this.audioContext.resume();
                        }
                    },
                    playAlert(type) {
                        // Create audio context for notification sound
                        try {
                            if (!this.audioContext) {
                                const AudioContext = window.AudioContext || window.webkitAudioContext;
                                this.audioContext = new AudioContext();
                            }
                            
                            // Resume if suspended
                            if (this.audioContext.state === 'suspended') {
                                this.audioContext.resume();
                            }
                            
                            const audioCtx = this.audioContext;
                            
                            // Different tones for different alerts
                            let frequency, volume, beepCount;
                            if (type === 'tenMin') {
                                frequency = 440; // A4 note
                                volume = 0.3;
                                beepCount = 1;
                            } else if (type === 'fiveMin') {
                                frequency = 523.25; // C5 note
                                volume = 0.4;
                                beepCount = 2;
                            } else if (type === 'oneMin') {
                                frequency = 659.25; // E5 note
                                volume = 0.5;
                                beepCount = 3;
                                this.isPulsing = true;
                            }
                            
                            this.playBeepSequence(audioCtx, frequency, volume, beepCount);
                        } catch (e) {
                            console.log('Audio notification error:', e);
                        }
                    },
                    playBeepSequence(audioCtx, frequency, volume, count) {
                        for (let i = 0; i < count; i++) {
                            setTimeout(() => {
                                const oscillator = audioCtx.createOscillator();
                                const gainNode = audioCtx.createGain();
                                
                                oscillator.connect(gainNode);
                                gainNode.connect(audioCtx.destination);
                                
                                oscillator.frequency.value = frequency;
                                oscillator.type = 'sine';
                                gainNode.gain.value = volume;
                                
                                const now = audioCtx.currentTime;
                                oscillator.start(now);
                                oscillator.stop(now + 0.15);
                            }, i * 250);
                        }
                    },
                    checkAlerts() {
                        // 10 minutes warning (600 seconds) - use <= to catch it even if we miss exact second
                        if (this.timeRemaining <= 600 && this.timeRemaining > 595 && !this.alertsPlayed.tenMin) {
                            this.alertsPlayed.tenMin = true;
                            this.playAlert('tenMin');
                        }
                        // 5 minutes warning (300 seconds)
                        if (this.timeRemaining <= 300 && this.timeRemaining > 295 && !this.alertsPlayed.fiveMin) {
                            this.alertsPlayed.fiveMin = true;
                            this.playAlert('fiveMin');
                        }
                        // 1 minute warning (60 seconds)
                        if (this.timeRemaining <= 60 && this.timeRemaining > 55 && !this.alertsPlayed.oneMin) {
                            this.alertsPlayed.oneMin = true;
                            this.playAlert('oneMin');
                        }
                    },
                    startTimer() {
                        this.timerInterval = setInterval(() => {
                            if (this.timeRemaining > 0) {
                                this.timeRemaining--;
                                this.checkAlerts();
                            } else {
                                clearInterval(this.timerInterval);
                                $wire.handleTimeExpired();
                            }
                        }, 1000);
                    }
                }"
                x-init="startTimer()"
                @click.window.once="initAudio()"
                x-on:beforeunmount.window="clearInterval(timerInterval)"
                :class="{
                    'bg-red-600': isWarning,
                    'bg-gray-900': !isWarning,
                    'animate-pulse': isPulsing
                }"
                class="flex items-center px-4 py-2 text-white rounded-lg font-mono text-lg transition-all"
            >
                <svg 
                    class="w-5 h-5 mr-2"
                    :class="{ 'animate-bounce': isCritical }"
                    fill="none" 
                    viewBox="0 0 24 24" 
                    stroke-width="1.5" 
                    stroke="currentColor"
                >
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <span x-text="display">00:00</span>
            </div>
        @endteleport
    @endif

    @if(!$examStarted)
            {{-- Pre-Exam Screen --}}
            <div class="max-w-2xl mx-auto">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                    @if($needsAccessCode)
                        {{-- Access Code Entry --}}
                        <div class="p-8 text-center">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 002.25-2.25v-6.75a2.25 2.25 0 00-2.25-2.25H6.75a2.25 2.25 0 00-2.25 2.25v6.75a2.25 2.25 0 002.25 2.25z" />
                            </svg>
                            <h2 class="mt-4 text-xl font-semibold text-gray-900">Access Code Required</h2>
                            <p class="mt-2 text-sm text-gray-500">Enter the access code provided by your instructor to proceed.</p>
                            
                            <div class="mt-6">
                                <input 
                                    type="text" 
                                    wire:model="accessCode"
                                    placeholder="Enter access code"
                                    class="block w-full text-center text-lg py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500"
                                >
                                @error('accessCode')
                                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <button 
                                wire:click="verifyAccessCode"
                                class="mt-4 w-full inline-flex justify-center items-center px-4 py-3 border border-transparent text-sm font-medium rounded-lg text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500"
                            >
                                Verify Code
                            </button>
                        </div>
                    @else
                        {{-- Exam Instructions --}}
                        <div class="p-6 border-b border-gray-200">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800 mb-2">
                                {{ $exam->code }}
                            </span>
                            <h1 class="text-2xl font-bold text-gray-900">{{ $exam->title }}</h1>
                            @if($session->title)
                                <p class="text-sm text-gray-500">{{ $session->title }}</p>
                            @endif
                        </div>

                        <div class="p-6 space-y-6">
                            {{-- Exam Details --}}
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                                <div class="text-center p-4 bg-gray-50 rounded-lg">
                                    <p class="text-2xl font-bold text-gray-900">{{ $exam->duration_minutes }}</p>
                                    <p class="text-sm text-gray-500">Minutes</p>
                                </div>
                                <div class="text-center p-4 bg-gray-50 rounded-lg">
                                    <p class="text-2xl font-bold text-gray-900">{{ $exam->total_questions }}</p>
                                    <p class="text-sm text-gray-500">Questions</p>
                                </div>
                                <div class="text-center p-4 bg-gray-50 rounded-lg">
                                    <p class="text-2xl font-bold text-gray-900">{{ $exam->passing_score }}%</p>
                                    <p class="text-sm text-gray-500">Pass Mark</p>
                                </div>
                                <div class="text-center p-4 bg-gray-50 rounded-lg">
                                    <p class="text-2xl font-bold text-gray-900">{{ $exam->total_marks }}</p>
                                    <p class="text-sm text-gray-500">Total Marks</p>
                                </div>
                            </div>

                            {{-- Instructions --}}
                            @if($exam->instructions)
                                <div class="prose prose-sm max-w-none">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Instructions</h3>
                                    <div class="p-4 bg-yellow-50 border border-yellow-200 rounded-lg text-sm text-yellow-800">
                                        {!! nl2br(e($exam->instructions)) !!}
                                    </div>
                                </div>
                            @endif

                            {{-- Rules --}}
                            <div class="space-y-3">
                                <h3 class="text-lg font-semibold text-gray-900">Exam Rules</h3>
                                <ul class="space-y-2 text-sm text-gray-600">
                                    <li class="flex items-start">
                                        <svg class="h-5 w-5 text-gray-400 mr-2 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        The exam will automatically submit when the timer reaches zero.
                                    </li>
                                    @if($exam->shuffle_questions)
                                    <li class="flex items-start">
                                        <svg class="h-5 w-5 text-gray-400 mr-2 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M7.5 21L3 16.5m0 0L7.5 12M3 16.5h13.5m0-13.5L21 7.5m0 0L16.5 12M21 7.5H7.5" />
                                        </svg>
                                        Questions will be presented in random order.
                                    </li>
                                    @endif
                                    @if($exam->allow_review)
                                    <li class="flex items-start">
                                        <svg class="h-5 w-5 text-gray-400 mr-2 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        You can navigate between questions and review your answers before submitting.
                                    </li>
                                    @endif
                                    @if($exam->negative_marking > 0)
                                    <li class="flex items-start text-red-600">
                                        <svg class="h-5 w-5 text-red-400 mr-2 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" />
                                        </svg>
                                        <strong>Negative marking:</strong> {{ $exam->negative_marking }} mark(s) will be deducted for each wrong answer.
                                    </li>
                                    @endif
                                    <li class="flex items-start">
                                        <svg class="h-5 w-5 text-gray-400 mr-2 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                                        </svg>
                                        Do not close or refresh the browser window during the exam.
                                    </li>
                                </ul>
                            </div>

                            {{-- Agreement --}}
                            <div class="p-4 bg-gray-50 border border-gray-200 rounded-lg">
                                <p class="text-sm text-gray-600">
                                    By starting this exam, you agree to abide by all examination rules and regulations. 
                                    Any form of cheating or malpractice may result in disqualification.
                                </p>
                            </div>
                        </div>

                        {{-- Start Button --}}
                        <div class="p-6 bg-gray-50 border-t border-gray-200">
                            <div class="flex items-center justify-between">
                                <a href="{{ route('exam.list') }}" class="text-sm text-gray-600 hover:text-gray-900">
                                    ← Back to Exam List
                                </a>
                                <button 
                                    wire:click="startExam"
                                    wire:loading.attr="disabled"
                                    class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-lg text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 disabled:opacity-50"
                                >
                                    <span wire:loading wire:target="startExam" class="inline-flex items-center">
                                        <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" fill="none" viewBox="0 0 24 24">
                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                        </svg>
                                        Starting...
                                    </span>
                                    <span wire:loading.remove wire:target="startExam">
                                        Start Exam
                                    </span>
                                </button>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @else
            {{-- Exam Interface --}}
            <div class="flex gap-6">
                {{-- Main Question Area --}}
                <div class="flex-1">
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                        {{-- Question Header --}}
                        <div class="px-6 py-4 border-b border-gray-200 flex items-center justify-between">
                            <div>
                                <span class="text-sm text-gray-500">Question {{ $currentIndex + 1 }} of {{ count($attempt->question_order) }}</span>
                                <span class="ml-2 text-xs text-gray-400">({{ $currentQuestion->marks ?? 1 }} mark{{ ($currentQuestion->marks ?? 1) > 1 ? 's' : '' }})</span>
                            </div>
                            <button 
                                wire:click="flagQuestion"
                                class="inline-flex items-center px-3 py-1.5 text-sm {{ $navigationData[$currentIndex]['is_flagged'] ?? false ? 'text-amber-600 bg-amber-50' : 'text-gray-600 bg-gray-50' }} rounded-lg hover:bg-gray-100"
                            >
                                <svg class="h-4 w-4 mr-1" fill="{{ $navigationData[$currentIndex]['is_flagged'] ?? false ? 'currentColor' : 'none' }}" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 3v1.5M3 21v-6m0 0l2.77-.693a9 9 0 016.208.682l.108.054a9 9 0 006.086.71l3.114-.732a48.524 48.524 0 01-.005-10.499l-3.11.732a9 9 0 01-6.085-.711l-.108-.054a9 9 0 00-6.208-.682L3 4.5M3 15V4.5" />
                                </svg>
                                {{ $navigationData[$currentIndex]['is_flagged'] ?? false ? 'Flagged' : 'Flag for Review' }}
                            </button>
                        </div>

                        {{-- Question Content --}}
                        <div class="p-6">
                            @if($currentQuestion)
                                <div class="prose prose-sm max-w-none mb-6">
                                    <p class="text-lg text-gray-900">{{ $currentQuestion->question_text }}</p>
                                </div>

                                @if($currentQuestion->isEssay())
                                    {{-- Essay Answer Input --}}
                                    <div class="space-y-3" wire:key="question-{{ $currentQuestion->id }}-essay">
                                        <div class="flex items-center justify-between mb-2">
                                            <span class="text-sm font-medium text-gray-700">Your Answer</span>
                                            @if($currentQuestion->min_words || $currentQuestion->max_words)
                                                <span class="text-xs text-gray-500">
                                                    @if($currentQuestion->min_words && $currentQuestion->max_words)
                                                        {{ $currentQuestion->min_words }} - {{ $currentQuestion->max_words }} words
                                                    @elseif($currentQuestion->min_words)
                                                        Minimum {{ $currentQuestion->min_words }} words
                                                    @else
                                                        Maximum {{ $currentQuestion->max_words }} words
                                                    @endif
                                                </span>
                                            @endif
                                        </div>
                                        
                                        <div 
                                            x-data="{ 
                                                text: $wire.entangle('essayAnswer'),
                                                get wordCount() {
                                                    if (!this.text) return 0;
                                                    return this.text.trim().split(/\s+/).filter(word => word.length > 0).length;
                                                },
                                                get isValid() {
                                                    const min = {{ $currentQuestion->min_words ?? 0 }};
                                                    const max = {{ $currentQuestion->max_words ?? 0 }};
                                                    if (min && this.wordCount < min) return false;
                                                    if (max && this.wordCount > max) return false;
                                                    return true;
                                                }
                                            }"
                                        >
                                            <textarea 
                                                wire:model.live.debounce.500ms="essayAnswer"
                                                rows="10"
                                                placeholder="Type your answer here..."
                                                class="w-full border border-gray-300 rounded-lg shadow-sm focus:ring-emerald-500 focus:border-emerald-500 p-4 text-gray-900 resize-y"
                                            ></textarea>
                                            
                                            <div class="flex items-center justify-between mt-2">
                                                <span 
                                                    class="text-sm"
                                                    :class="isValid ? 'text-gray-500' : 'text-amber-600'"
                                                >
                                                    <span x-text="wordCount">0</span> words
                                                </span>
                                                <span class="text-xs text-gray-400">
                                                    <svg class="inline-block h-3 w-3 mr-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z" />
                                                    </svg>
                                                    This question requires manual grading
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                @else
                                    {{-- Multiple Choice Options --}}
                                    <div class="space-y-3" wire:key="question-{{ $currentQuestion->id }}-options">
                                        @foreach($currentQuestion->formatted_options as $key => $option)
                                            <label 
                                                wire:key="option-{{ $currentQuestion->id }}-{{ $key }}"
                                                class="flex items-center p-4 border rounded-lg cursor-pointer transition-colors {{ $selectedAnswer === $key ? 'border-emerald-500 bg-emerald-50' : 'border-gray-200 hover:bg-gray-50' }}"
                                            >
                                                <input 
                                                    type="radio" 
                                                    wire:click="selectAnswer('{{ $key }}')"
                                                    name="answer_{{ $currentQuestion->id }}"
                                                    value="{{ $key }}"
                                                    @checked($selectedAnswer === $key)
                                                    class="h-4 w-4 text-emerald-600 focus:ring-emerald-500 border-gray-300"
                                                />
                                                <span class="ml-3 flex-1">
                                                    <span class="font-medium text-gray-700 mr-2">{{ $key }}.</span>
                                                    <span class="text-gray-900">{{ $option }}</span>
                                                </span>
                                            </label>
                                        @endforeach
                                    </div>
                                @endif
                            @else
                                <p class="text-gray-500">Question not found.</p>
                            @endif
                        </div>

                        {{-- Navigation Buttons --}}
                        <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex items-center justify-between">
                            <button 
                                wire:click="saveAndPrevious"
                                @if($currentIndex === 0) disabled @endif
                                class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 disabled:opacity-50 disabled:cursor-not-allowed"
                            >
                                <svg class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5L8.25 12l7.5-7.5" />
                                </svg>
                                Previous
                            </button>

                            {{-- Auto-save indicator --}}
                            <span class="text-xs text-gray-400 flex items-center">
                                <svg class="h-3 w-3 mr-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                Answers auto-saved
                            </span>

                            @if($currentIndex === count($attempt->question_order) - 1)
                                <button 
                                    wire:click="confirmSubmit"
                                    class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-emerald-600 hover:bg-emerald-700"
                                >
                                    Review & Submit
                                    <svg class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M4.5 12.75l6 6 9-13.5" />
                                    </svg>
                                </button>
                            @else
                                <button 
                                    wire:click="saveAndNext"
                                    class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-emerald-600 hover:bg-emerald-700"
                                >
                                    Next
                                    <svg class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" />
                                    </svg>
                                </button>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- Question Navigation Sidebar --}}
                <div class="w-72 flex-shrink-0">
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden sticky top-4">
                        <div class="px-4 py-3 border-b border-gray-200">
                            <h3 class="font-semibold text-gray-900">Question Navigator</h3>
                            <p class="text-xs text-gray-500 mt-1">
                                {{ $progress['answered'] ?? 0 }} of {{ $progress['total'] ?? 0 }} answered
                            </p>
                        </div>

                        <div class="p-4">
                            {{-- Progress Bar --}}
                            <div class="mb-4">
                                <div class="w-full bg-gray-200 rounded-full h-2">
                                    <div 
                                        class="bg-emerald-600 h-2 rounded-full transition-all" 
                                        style="width: {{ $progress['progress_percentage'] ?? 0 }}%"
                                    ></div>
                                </div>
                            </div>

                            {{-- Question Grid --}}
                            <div class="grid grid-cols-5 gap-2">
                                @foreach($navigationData as $nav)
                                    <button 
                                        wire:click="goToQuestion({{ $nav['index'] }})"
                                        class="w-10 h-10 text-sm font-medium rounded-lg border-2 transition-colors
                                            @if($nav['is_current'])
                                                border-emerald-500 bg-emerald-500 text-white
                                            @elseif($nav['is_flagged'])
                                                border-amber-400 bg-amber-50 text-amber-700
                                            @elseif($nav['is_answered'])
                                                border-emerald-400 bg-emerald-50 text-emerald-700
                                            @else
                                                border-gray-200 bg-white text-gray-600 hover:bg-gray-50
                                            @endif
                                        "
                                    >
                                        {{ $nav['index'] + 1 }}
                                    </button>
                                @endforeach
                            </div>

                            {{-- Legend --}}
                            <div class="mt-4 pt-4 border-t border-gray-200 space-y-2 text-xs">
                                <div class="flex items-center">
                                    <span class="w-4 h-4 rounded bg-emerald-500 mr-2"></span>
                                    <span class="text-gray-600">Current</span>
                                </div>
                                <div class="flex items-center">
                                    <span class="w-4 h-4 rounded bg-emerald-50 border border-emerald-400 mr-2"></span>
                                    <span class="text-gray-600">Answered</span>
                                </div>
                                <div class="flex items-center">
                                    <span class="w-4 h-4 rounded bg-amber-50 border border-amber-400 mr-2"></span>
                                    <span class="text-gray-600">Flagged</span>
                                </div>
                                <div class="flex items-center">
                                    <span class="w-4 h-4 rounded bg-white border border-gray-200 mr-2"></span>
                                    <span class="text-gray-600">Not Answered</span>
                                </div>
                            </div>
                        </div>

                        {{-- Submit Button --}}
                        <div class="px-4 py-3 bg-gray-50 border-t border-gray-200">
                            <button 
                                wire:click="confirmSubmit"
                                class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-red-600 hover:bg-red-700"
                            >
                                Submit Exam
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Submit Confirmation Modal --}}
            <div 
                x-data="{ open: @entangle('showConfirmSubmit') }"
                x-show="open"
                x-cloak
                class="fixed inset-0 z-50 overflow-y-auto" 
                aria-labelledby="modal-title" 
                role="dialog" 
                aria-modal="true"
            >
                <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:p-0">
                    {{-- Backdrop --}}
                    <div 
                        x-show="open"
                        x-transition:enter="ease-out duration-200"
                        x-transition:enter-start="opacity-0"
                        x-transition:enter-end="opacity-100"
                        x-transition:leave="ease-in duration-150"
                        x-transition:leave-start="opacity-100"
                        x-transition:leave-end="opacity-0"
                        class="fixed inset-0 bg-gray-500 bg-opacity-75" 
                        @click="$wire.cancelSubmit()"
                    ></div>

                    {{-- Modal Panel --}}
                    <div 
                        x-show="open"
                        x-transition:enter="ease-out duration-200"
                        x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                        x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                        x-transition:leave="ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                        x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                        class="relative inline-block bg-white rounded-lg text-left overflow-hidden shadow-xl sm:my-8 sm:max-w-lg sm:w-full"
                    >
                        <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                            <div class="sm:flex sm:items-start">
                                <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-amber-100 sm:mx-0 sm:h-10 sm:w-10">
                                    <svg class="h-6 w-6 text-amber-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" />
                                    </svg>
                                </div>
                                <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                        Submit Exam?
                                    </h3>
                                    <div class="mt-2">
                                        <p class="text-sm text-gray-500">
                                            Are you sure you want to submit your exam? This action cannot be undone.
                                        </p>

                                        <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                                            <dl class="grid grid-cols-2 gap-4 text-sm">
                                                <div>
                                                    <dt class="text-gray-500">Answered</dt>
                                                    <dd class="font-medium text-emerald-600">{{ $progress['answered'] ?? 0 }}</dd>
                                                </div>
                                                <div>
                                                    <dt class="text-gray-500">Skipped</dt>
                                                    <dd class="font-medium text-amber-600">{{ $progress['skipped'] ?? 0 }}</dd>
                                                </div>
                                                <div>
                                                    <dt class="text-gray-500">Flagged</dt>
                                                    <dd class="font-medium text-amber-600">{{ $progress['flagged'] ?? 0 }}</dd>
                                                </div>
                                                <div>
                                                    <dt class="text-gray-500">Total</dt>
                                                    <dd class="font-medium text-gray-900">{{ $progress['total'] ?? 0 }}</dd>
                                                </div>
                                            </dl>
                                        </div>

                                        @if(($progress['skipped'] ?? 0) > 0)
                                            <p class="mt-3 text-sm text-amber-600">
                                                ⚠️ You have {{ $progress['skipped'] ?? 0 }} unanswered question(s).
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                            <button 
                                wire:click="submitExam"
                                wire:loading.attr="disabled"
                                type="button" 
                                class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-emerald-600 text-base font-medium text-white hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 sm:ml-3 sm:w-auto sm:text-sm disabled:opacity-50"
                            >
                                <span wire:loading wire:target="submitExam" class="inline-flex items-center">
                                    <svg class="animate-spin -ml-1 mr-2 h-4 w-4 text-white" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                    Submitting...
                                </span>
                                <span wire:loading.remove wire:target="submitExam">
                                    Yes, Submit
                                </span>
                            </button>
                            <button 
                                wire:click="cancelSubmit"
                                type="button" 
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm"
                            >
                                Continue Exam
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
</div>
